/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import com.cgessinger.creaturesandbeasts.common.init.ModItems;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import com.cgessinger.creaturesandbeasts.common.interfaces.IAnimationHolder;
import com.cgessinger.creaturesandbeasts.common.util.AnimationHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CindershellEntity
extends AnimalEntity
implements IAnimationHolder<CindershellEntity> {
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    private final float babyHealth = 10.0f;
    private static final DataParameter<Boolean> EAT = EntityDataManager.func_187226_a(CindershellEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<ItemStack> HOLDING = EntityDataManager.func_187226_a(CindershellEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private final AnimationHandler<CindershellEntity> animationHandler = new AnimationHandler<CindershellEntity>("eat_controller", this, 40, 1, 0, EAT);

    public CindershellEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EAT, (Object)false);
        this.field_70180_af.func_187214_a(HOLDING, (Object)ItemStack.field_190927_a);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal(this, 1.0){

            protected void func_75388_i() {
                int range = this.field_75390_d.func_70681_au().nextInt(4) + 3;
                for (int i = 0; i <= range; ++i) {
                    super.func_75388_i();
                }
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233820_c_, 100.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (dataTag != null) {
            if (dataTag.func_74764_b("age")) {
                this.func_70873_a(dataTag.func_74762_e("age"));
            }
            if (dataTag.func_74764_b("health")) {
                this.func_70606_j(dataTag.func_74760_g("health"));
            }
            if (dataTag.func_74764_b("name")) {
                this.func_200203_b(ITextComponent.func_244388_a((String)dataTag.func_74779_i("name")));
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.animationHandler.process();
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        double MAX_HEALTH = this.func_110148_a(Attributes.field_233818_a_).func_111126_e();
        if (this.func_70631_g_()) {
            Objects.requireNonNull(this);
            if (MAX_HEALTH > 10.0) {
                HashMultimap multimap = HashMultimap.create();
                Objects.requireNonNull(this);
                multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", 10.0 - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
                this.func_233645_dx_().func_233793_b_((Multimap)multimap);
                this.func_70606_j(this.babyHealth);
            }
        }
    }

    protected void func_175500_n() {
        super.func_175500_n();
        this.func_110148_a(Attributes.field_233818_a_).func_188479_b(this.healthReductionUUID);
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
    }

    public float func_213307_e(Pose pose) {
        return this.func_213302_cg() * 0.2f;
    }

    public static boolean canCindershellSpawn(EntityType<CindershellEntity> p_234418_0_, IWorld p_234418_1_, SpawnReason p_234418_2_, BlockPos p_234418_3_, Random p_234418_4_) {
        return true;
    }

    public void setHolding(ItemStack stack) {
        this.field_70180_af.func_187227_b(HOLDING, (Object)stack);
    }

    public ItemStack getHolding() {
        return (ItemStack)this.field_70180_af.func_187225_a(HOLDING);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)ModEntityTypes.CINDERSHELL.get()).func_200721_a((World)p_241840_1_);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEventTypes.CINDERSHELL_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEventTypes.CINDERSHELL_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEventTypes.CINDERSHELL_HURT.get();
    }

    protected float func_70599_aP() {
        return super.func_70599_aP() * 2.0f;
    }

    public int func_70627_aG() {
        return 120;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.CINDERSHELL_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public ActionResultType tryStartEat(PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() == Items.field_234722_bw_ || stack.func_77973_b() == Items.field_234723_bx_) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.func_204701_dC()) {
                this.func_175505_a(player, stack);
                this.animationHandler.startAnimation(AnimationHandler.ExecutionData.create().withPlayer(player).build());
                this.func_184185_a((SoundEvent)ModSoundEventTypes.CINDERSHELL_ADULT_EAT.get(), 1.2f, 1.0f);
                this.setHolding(stack);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70631_g_()) {
                this.func_184185_a((SoundEvent)ModSoundEventTypes.CINDERSHELL_BABY_EAT.get(), 1.3f, 1.0f);
                this.func_175505_a(player, stack);
                this.func_175501_a((int)((float)(-i) / 20.0f * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (item.func_77973_b() == Items.field_151129_at && this.func_70631_g_()) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.CINDERSHELL_BUCKET.get(), item.func_190916_E());
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74768_a("age", this.func_70874_b());
            nbt.func_74776_a("health", this.func_110143_aJ());
            if (this.func_145818_k_()) {
                nbt.func_74778_a("name", this.func_200201_e().getString());
            }
            player.func_184611_a(hand, stack);
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return this.tryStartEat(player, item);
    }

    @Override
    public void executeBreakpoint(Optional<AnimationHandler.ExecutionData> data) {
        if (data.isPresent() && data.get().player != null) {
            this.func_146082_f(data.get().player);
            this.setHolding(ItemStack.field_190927_a);
        }
    }

    @Override
    public AnimationHandler<CindershellEntity> getAnimationHandler(String name) {
        return this.animationHandler;
    }
}

